REBOL [
    subject: "cration ou modification d'une description"
    author: "Olivier Auverlot"
]

; lecture des paramtres transmis
var: make object! decode-cgi system/options/cgi/query-string
clescript: to-integer var/clescript

print "Content-type: text/html^/"
print {
    <HTML>
    </HEAD>
        <TITLE>Cration/Edition d'un script</TITLE>
    </HEAD>
    <BODY>
}

; affichage des options
options: copy {
    <A href="javascript: fiche.submit()">Valider</A>
    <A href="listescripts.cgi">Annuler</A>
    <A href="editcateg.cgi?clescript=-CLESCRIPT-&clecateg=0">Catgories</A>
}
if clescript <> 0 [
    append options join {<A href="modifscript.cgi?action=3&clescript=} [
        clescript {">Effacer</A>}
    ]
]
replace/all options "-CLESCRIPT-" clescript
print [ options "<HR>" ]

; corps du formulaire
formulaire: copy {
    <FORM name="fiche" method="POST" action="modifscript.cgi">
    Titre<BR>
    <INPUT name="titre" type="field" value="-TITRE-"><BR>
    Catgorie<BR>
    <SELECT name="categorie" size="1">
        -OPTIONS-
    </SELECT><BR>
    Description<BR>
    <INPUT name="description" type="field" value="-DESCRIPTION-"><BR>
    Auteur<BR>
    <INPUT name="auteur" type="field" value="-AUTEUR-"><BR>
 }

; ajout des variables caches
append formulaire join {<INPUT type="hidden" name="clescript" value="} [
    clescript {">}
]
either clescript <> 0 [
    ; mode dition
    append formulaire {<INPUT type="hidden" name="action" value="2">}
] [
    ; mode cration
    append formulaire {<INPUT type="hidden" name="action" value="1">}
]

; fermeture du formulaire
append formulaire "</FORM>"

; ouverture de la base
db: open odbc://scripts
p: first db

; lecture des informations sur le script

either clescript <> 0 [
    insert p [ 
        "SELECT titre, categorie, description, auteur FROM scripts WHERE cle=?" 
        clescript
    ]
    resultat: copy p
    replace formulaire "-TITRE-" resultat/1/1
    replace formulaire "-DESCRIPTION-" resultat/1/3
    replace formulaire "-AUTEUR-" resultat/1/4
    categ: resultat/1/2
] [
   replace formulaire "-TITRE-" ""
   replace formulaire "-DESCRIPTION-" ""
   replace formulaire "-AUTEUR-" ""
   categ: 0
]

; lecture des catgories
insert p "SELECT * FROM categories ORDER BY categorie asc"
liste-options: copy p

; construction de la liste droulante des catgories
options: copy ""
foreach ligne liste-options [
    append options reduce [
        either (ligne/1 = categ) [
            join "<OPTION value=" [ ligne/1 " SELECTED >" ligne/2 ]
        ] [
            join "<OPTION value=" [ ligne/1 ">" ligne/2 ]
        ]
    ]
]
replace formulaire "-OPTIONS-" options

; fermeture de la base
close p
close db

; affichage du formulaire
print formulaire